<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ProjectCertificateSeeder extends Seeder
{
    public function run()
    {
        // Clear existing data
        $this->db->table('projects')->truncate();
        $this->db->table('organizations')->truncate();
        $this->db->table('training')->truncate();
        $this->db->table('certificates')->truncate();

        // Insert Projects one by one
        $projects = [
            [
                'nama_project' => 'Website Digital Banking',
                'jenis_project' => 'Web',
                'teknologi' => 'Laravel, PHP, SQL, MySQL',
                'tahun' => 2024,
                'deskripsi' => 'Website perbankan yang menampilkan fitur-fitur layanan seperti tampilan saldo, transfer, pembayaran merchant dsb.',
                'link_project' => '',
                'urutan' => 1
            ],
            [
                'nama_project' => 'Tempat Sampah Otomatis Organik dan Non-Organik',
                'jenis_project' => 'Lainnya',
                'teknologi' => 'Machine Learning, ESP32 cam, sensor IR',
                'tahun' => 2024,
                'deskripsi' => 'Sistem klasifikasi untuk membedakan sampah kategori organik & non-organik. Membuat prototype tempat sampah dari bahan daur ulang dan menempatkan sistem tersebut.',
                'link_project' => '',
                'urutan' => 2
            ],
            [
                'nama_project' => 'Website Portofolio',
                'jenis_project' => 'Web',
                'teknologi' => 'HTML, CSS, JS',
                'tahun' => 2024,
                'deskripsi' => 'Portofolio responsif yang menampilkan halaman profil, project, & contact.',
                'link_project' => '',
                'urutan' => 3,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_project' => 'Aplikasi Mobile CV',
                'jenis_project' => 'Mobile',
                'teknologi' => 'Android Studio',
                'tahun' => 2024,
                'deskripsi' => 'Aplikasi Mobile Android dengan tampilan warna pink-peach sakura yang menampilkan halaman Profil, Kegiatan, & Pendidikan. Responsif, dengan tampilan tautan aktif pada halaman tertentu (Github, linkedln, instagram).',
                'link_project' => '',
                'urutan' => 4,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];

        // Insert Organizations
        $organizations = [
            [
                'nama_organisasi' => 'HIMAKOM (Himpunan Mahasiswa Ilmu Komputer)',
                'jabatan' => 'Anggota Divisi Akademik',
                'tahun_mulai' => 2025,
                'tahun_selesai' => null, // Masih aktif
                'deskripsi' => 'Membantu monitoring perkembangan akademik anggota serta menyusun laporan evaluasi. Mengkoordinasi pelaksanaan sesi diskusi, workshop, dan kelas pengayaan setiap bulan untuk meningkatkan kualitas akademik mahasiswa Ilmu Komputer.',
                'urutan' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];

        // Insert Training/Certificates
        $trainings = [
            [
                'nama_pelatihan' => 'PR Intern KOMINFO',
                'penyelenggara' => 'KOMINFO',
                'tanggal_mulai' => '2024-10-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Pelatihan Public Relations dengan modul: Berita Edukasi Siber Sosial Terkini. Mengembangkan kemampuan komunikasi publik dan pengelolaan informasi digital untuk meningkatkan literasi masyarakat.',
                'sertifikat' => 'certificate_pr_kominfo.pdf',
                'urutan' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'AI',
                'penyelenggara' => 'Dicoding Indonesia',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Pelatihan Artificial Intelligence dengan modul: Belajar Dasar AI, AI Praktis untuk Produktivitas, dan Belajar Penggunaan Generative AI. Memahami konsep AI dan implementasinya dalam meningkatkan produktivitas.',
                'sertifikat' => 'certificate_ai_dicoding.pdf',
                'urutan' => 2,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Python',
                'penyelenggara' => 'Dicoding Indonesia',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Pelatihan Python Programming dengan modul: Memulai Pemrograman dengan Python. Mempelajari fundamental programming Python untuk pengembangan aplikasi dan data science.',
                'sertifikat' => 'certificate_python_dicoding.pdf',
                'urutan' => 3,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Data & Visual Data',
                'penyelenggara' => 'Dicoding Indonesia',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Pelatihan Data Science dengan modul: Belajar Data Science, Belajar Dasar Visualisasi Data, dan Belajar Dasar Structured Query Language (SQL). Mengembangkan kemampuan analisis dan visualisasi data.',
                'sertifikat' => 'certificate_data_visual_dicoding.pdf',
                'urutan' => 4,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Data Science',
                'penyelenggara' => 'DQLab Academy',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Pelatihan Data Science dengan modul: R Fundamental for Data Science, Python Fundamental for Data Science, dan Fundamental SQL Using SELECT Statement. Memberikan foundation yang kuat untuk analisis data.',
                'sertifikat' => 'certificate_data_science_dqlab.pdf',
                'urutan' => 5,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Matlab',
                'penyelenggara' => 'MathWorks',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Pelatihan MATLAB dengan modul: MATLAB Onramp dan Control Design Onramp with Simulink. Mempelajari pemrograman MATLAB untuk komputasi teknis dan sistem kontrol.',
                'sertifikat' => 'certificate_matlab_mathworks.pdf',
                'urutan' => 6,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'FORTECHBI',
                'penyelenggara' => 'HIMAKOM',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Pelatihan teknologi dengan modul: ML & AI, Studi Kasus Aplikasi AI di Pendidikan, dan Etika dan Pemanfaatan AI. Memahami implementasi AI dalam pendidikan dan aspek etika penggunaan teknologi AI.',
                'sertifikat' => 'certificate_fortechbi_himakom.pdf',
                'urutan' => 7,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];

        // Insert Certificates (from training data)
        $certificates = [
            [
                'nama_sertifikat' => 'PR Intern KOMINFO Certificate',
                'penerbit' => 'KOMINFO',
                'tanggal_terbit' => '2024-12-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'KOMINFO-PR-2024-001',
                'link_sertifikat' => 'https://kominfo.go.id/certificate/KOMINFO-PR-2024-001',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Public Relations Intern yang memvalidasi kompetensi dalam pengelolaan informasi publik, komunikasi digital, dan literasi siber. Menunjukkan kemampuan dalam menyebarluaskan informasi pemerintah kepada masyarakat.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_sertifikat' => 'AI Certificate',
                'penerbit' => 'Dicoding Indonesia',
                'tanggal_terbit' => '2024-12-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'DCD-AI-2024-002',
                'link_sertifikat' => 'https://dicoding.com/certificate/DCD-AI-2024-002',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat AI yang memvalidasi pemahaman dasar Artificial Intelligence, penggunaan AI untuk produktivitas, dan implementasi Generative AI. Menunjukkan kompetensi dalam teknologi AI modern.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_sertifikat' => 'Python Programming Certificate',
                'penerbit' => 'Dicoding Indonesia',
                'tanggal_terbit' => '2024-12-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'DCD-PY-2024-003',
                'link_sertifikat' => 'https://dicoding.com/certificate/DCD-PY-2024-003',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Python Programming yang memvalidasi kemampuan fundamental programming Python. Menunjukkan kompetensi dalam pengembangan aplikasi dan data science menggunakan Python.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_sertifikat' => 'Data & Visual Data Certificate',
                'penerbit' => 'Dicoding Indonesia',
                'tanggal_terbit' => '2024-12-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'DCD-DVD-2024-004',
                'link_sertifikat' => 'https://dicoding.com/certificate/DCD-DVD-2024-004',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Data & Visual Data yang memvalidasi kemampuan data science, visualisasi data, dan SQL. Menunjukkan kompetensi dalam analisis dan presentasi data yang efektif.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_sertifikat' => 'Data Science Certificate',
                'penerbit' => 'DQLab Academy',
                'tanggal_terbit' => '2024-12-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'DQL-DS-2024-005',
                'link_sertifikat' => 'https://dqlab.id/certificate/DQL-DS-2024-005',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Data Science yang memvalidasi kompetensi dalam R Programming, Python for Data Science, dan SQL fundamentals. Menunjukkan kemampuan analisis data yang komprehensif.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_sertifikat' => 'MATLAB Certificate',
                'penerbit' => 'MathWorks',
                'tanggal_terbit' => '2024-12-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'MW-ML-2024-006',
                'link_sertifikat' => 'https://mathworks.com/certificate/MW-ML-2024-006',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat MATLAB yang memvalidasi kemampuan dalam MATLAB programming dan Control Design dengan Simulink. Menunjukkan kompetensi dalam komputasi teknis dan sistem kontrol.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_sertifikat' => 'FORTECHBI Certificate',
                'penerbit' => 'HIMAKOM',
                'tanggal_terbit' => '2024-12-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'HMK-FTB-2024-007',
                'link_sertifikat' => 'https://himakom.ac.id/certificate/HMK-FTB-2024-007',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat FORTECHBI yang memvalidasi pemahaman ML & AI, aplikasi AI dalam pendidikan, dan etika AI. Menunjukkan kompetensi dalam implementasi teknologi AI yang bertanggung jawab dan ethical.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];

        // Insert data one by one
        foreach ($projects as $project) {
            $this->db->table('projects')->insert($project);
        }
        
        foreach ($organizations as $organization) {
            $this->db->table('organizations')->insert($organization);
        }
        
        foreach ($trainings as $training) {
            $this->db->table('training')->insert($training);
        }
        
        foreach ($certificates as $certificate) {
            $this->db->table('certificates')->insert($certificate);
        }

        echo "✅ Project, Organization, Training, dan Certificate data berhasil dimigrasi!\n";
        echo "📊 Data yang diinsert:\n";
        echo "   - Projects: " . count($projects) . " records\n";
        echo "   - Organizations: " . count($organizations) . " records\n";
        echo "   - Training: " . count($trainings) . " records\n";
        echo "   - Certificates: " . count($certificates) . " records\n";
    }
}